**************************************************************************************************
*******************"ADOPTION OF GPT" PAPER - SET UP***********************************************
*************************DATE: OCT 2023 **********************************************************
************************ AUTHOR: KIM NGUYEN AND JONATHAN HAMBUR **********************************
**************************************************************************************************

clear all
set more off
set maxvar 30000
set matsize 10000

// IMPORT DATA
cd "Data Files"
use "morningstar_final.dta", clear
merge m:1 asxcode fy using "adoption_cleaned.dta", nogen keep(match master)
merge m:1 asxcode using "ASX People Board Current - by Firm.dta", nogen keep(match master)
merge m:1 asxcode using "list_dates.dta", nogen keep(match master)
merge 1:1 fy asxcode using "Hire_data_cur.dta", nogen keep(master match)


// CREATE VARIABLES

** Firm age
g age = year-list_year
replace age = 0 if age<0

** Adoption dummies
foreach x in dprinting autonomous_cars bispecific_monoclonal_antibody cloud_computing computer_vision drug_conjugates electronic_gaming fingerprint_sensor fracking gps hybrid_vehicle_electric_car lane_departure_warning lithium_battery machine_learning_ai millimeter_wave mobile_payment oled_display online_streaming rfid_tags search_engine smart_devices social_networking software_defined_radio solar_power stent_graft touch_screen virtual_reality wi_fi wireless_charging{
g `x'_i = (`x'>=1)
replace `x'_i = . if `x' == .
}

** Count of all techs
egen techcount = rowtotal(*_i)
replace techcount=. if hybrid_vehicle_electric_car==.
g tech_i = (techcount>=1)
replace tech_i=. if hybrid_vehicle_electric_car==.

** Set up GPT (Cloud, ML & AI)
g gentech1 = cloud_computing_i + machine_learning_ai_i
g gentech_i = .
replace gentech_i = 0 if gentech1 == 0
replace gentech_i = 1 if gentech1 >= 1 & gentech1 != .


// SET UP PANEL

egen id = group(asxcode)
xtset id fy

** Age in sample
bysort id: g yearcount = _n
bysort id: egen age_sample = max(yearcount)

** Relevant control variables
g logrevenuefy = log(revenuefy)
g logassets = log(assets)
g logcash = log(cashfy)
g logdebt = log(debt)
g Lrevenue = L.logrevenue
g Lassets = L.logassets
g Lcash = L.logcash
g Lgearing = L.gearingratiopreferred
g Ldebt = L.logdebt
g Lroe = L.roepreferred

g Drevenue = D.logrevenue
g Dassets = D.logassets
g Dcash = D.logcash
g Dgearing = D.gearingratiopreferred

g roe = ebitdafy/equity
g roe_an = ebitdaannual/equity
g roa = ebitdafy/assets
g roa_ann = ebitdaannual/assets
g roar = revenuefy/assets
g roan = (revenuefy + opexfy)/assets

** Firm size
g sme = 0
replace sme=1 if revenuefy < 10 & fy>=2015
replace sme=1 if revenuefy < 2 & fy<2015
g Lsme = L.sme

** Non-mining firms
g nonmining = (miningtenements557==. & miningproperty556==.)

** Investment and staff expenses
g fixedassets = totalfixedassets5030
replace fixedassets = totalfixedassets11080 if fixedassets==.
g investment = D.fixedassets
g loginvestment = log(investment)
g logpfassets = log(-pfassetsfy)
g invcf = -totalinvestingcashflow9200
g loginvcf = log(invcf)
g shortinv = totalshortterminvestments5010
g logshortinv = log(shortinv)
g staffexpenses = -staffexpfy
g logstaffexpenses = log(staffexpenses)
g Linvestment = L.investment
g Lstaffexpenses = L.staffexpenses
g Dstaffexpenses = D.logstaffexpenses
g logebitda = log(ebitdaannual)
g noemployees = numberofemployees708/1000
g logopex = log(-opexfy)

g caopex = - capexfy - opexfy
g roa_wcap = (ebitdafy + capexfy)/assets
g postgfc = (year>2010)

g labourshare = staffexpenses/revenuefy*100


** Variables as share of assets
g ebitda_sa = ebitdafy/assets
g revenue_sa = revenuefy/assets
g opex_sa = -opexfy/assets
g staffexpenses_sa = staffexpenses/assets
g caopex_sa = caopex/assets
g ebit_sa = ebitfy/assets


** Winsorise data
replace roa = 1 if roa>1 & roa!=.
replace roa = -1 if roa<-1 & roa!=.
replace roar = 1 if roar>1 & roar!=.
replace roar = -1 if roar<-1 & roar!=.
replace roe = 1 if roe>1 & roe!=.
replace roe = -1 if roe<-1 & roe!=.
replace roa_wcap = 1 if roa_wcap>1 & roa_wcap!=.
replace roa_wcap = -1 if roa_wcap<-1 & roa_wcap!=.
replace ebit_sa = 1 if ebit_sa>1 & ebit_sa!=.
replace ebit_sa = -1 if ebit_sa<-1 & ebit_sa!=.

replace labourshare = 0 if labourshare<0 & labourshare!=.
replace labourshare = 100 if labourshare>100 & labourshare!=.


replace revenuefy=0 if revenuefy<0
replace revenuefy=1000 if revenuefy>1000
replace assets=4000 if assets>4000
replace assets=0 if assets < 0
replace revenue_sa = 0 if revenue_sa<0 & revenue_sa!=.
replace revenue_sa = 2 if revenue_sa>2 & revenue_sa!=.
replace opex_sa = 0 if opex_sa<0 & revenue_sa!=.
replace opex_sa = 2 if opex_sa>2 & opex_sa!=.

*Rescale ratios
replace roa = roa*100
replace ebit_sa = ebit_sa*100
replace opex_sa = opex_sa*100
replace revenue_sa= 100*revenue_sa
replace roa_wcap= 100*roa_wcap

g pos_cf = ebitdafy>0

/// Time to tech adoption

foreach var in gentech cloud_computing machine_learning_ai {
	g `var'_1y= fy if `var'_i==1
	bysort id: egen `var'_iy = min(`var'_1y)
	g timeto`var'_i = fy - `var'_iy

}


foreach var in gentech cloud_computing machine_learning_ai  {
g `var'_by22 = 0
replace `var'_by22 = 1 if `var'_iy!=. & `var'_iy<=2022 
replace `var'_by22 = 0 if `var'_i==.
}

** early vs late adopters
g lateadopters = 0 if (gentech_iy==. & dprinting!=.)
replace lateadopters = 2 if gentech_iy>=2013 & gentech_iy<2017
replace lateadopters = 1 if gentech_iy>=2017 & gentech_iy!=.


** Ever adopted
** timing
g gentech_iy_m = 1 if fy == gentech_iy
replace gentech_iy_m = 0 if fy <gentech_iy & gentech_iy!=.
replace gentech_iy_m = 0 if (gentech_iy==. & dprinting!=.)
replace gentech_iy_m = . if fy> gentech_iy


* ever ever
bysort asxcode: egen ever_tech = max(gentech_i)
replace ever_tech=1 if ever_tech>1 & ever_tech!=.

* bring in hiring data
g cloud_computing_hire_i = (cloud_computing_hire>0)
replace cloud_computing_hire_i=. if cloud_computing_hire==.
g machine_learning_ai_hire_i = (machine_learning_ai_hire>0)
replace machine_learning_ai_hire_i = . if machine_learning_ai_hire==.
g tech_hire_i = machine_learning_ai_hire_i+cloud_computing_hire_i
replace  tech_hire_i = 1 if tech_hire_i>1 & tech_hire_i!=.
label var tech_hire_i "Firms Seeking GPT Skills"


bysort asxcode: egen ever_cl = max(cloud_computing_hire_i)
replace ever_cl=1 if ever_cl>1 & ever_cl!=.
bysort asxcode: egen ever_ml = max(machine_learning_ai_hire_i)
replace ever_ml=1 if ever_ml>1 & ever_ml!=.
g ever_h_tech= ever_cl +ever_ml 
replace ever_h_tech= 1 if ever_h_tech>1 & ever_h_tech!=.


// SAVE DATA FOR ANLYSIS
save "Final_data.dta", replace

// DESCRIPTIVE STATS

tabstat cloud_computing_i machine_learning_ai_i if sector == "Communications"
tabstat cloud_computing_i machine_learning_ai_i if sector == "Consumer discretionary"
tabstat cloud_computing_i machine_learning_ai_i if sector == "Consumer staples"
tabstat cloud_computing_i machine_learning_ai_i if sector == "Health"
tabstat cloud_computing_i machine_learning_ai_i if sector == "Energy"
tabstat cloud_computing_i machine_learning_ai_i if sector == "Materials"
tabstat cloud_computing_i machine_learning_ai_i if sector == "Financials"
tabstat cloud_computing_i machine_learning_ai_i if sector == "REITs"
tabstat cloud_computing_i machine_learning_ai_i if sector == "Utilities"
tabstat cloud_computing_i machine_learning_ai_i if sector == "Industrials"
tabstat cloud_computing_i machine_learning_ai_i if sector == "IT"

tabstat revenuefy debt cashfy assets investment staffexpenses roepreferred gearingratiopreferred if gentech_i==0 & fy>=2007, stats(median)
tabstat revenuefy debt cashfy assets investment staffexpenses roepreferred gearingratiopreferred if gentech_i==1 & fy>=2007, stats(median)
